@echo off
setlocal ENABLEDELAYEDEXPANSION

:: ===== Resolve script directory (trailing backslash) =====
set "SCRIPT_HOME_DIRECTORY=%~dp0"

:: ===== Get IP from arg or prompt (no parentheses in prompt text) =====
if "%~1"=="" goto ASK_IP
set "DEVICE_IP=%~1"
goto CONNECT

:ASK_IP
set /p "DEVICE_IP=Enter device IP, e.g. 192.168.1.50: "
if "%DEVICE_IP%"=="" (
  echo [ERROR] No IP provided.
  exit /b 1
)

:CONNECT
set "ADB_HOST=%DEVICE_IP%:5555"

:: ===== Ensure adb exists =====
where adb >nul 2>&1
if errorlevel 1 (
  echo [ERROR] adb not found in PATH. Install Android Platform Tools.
  exit /b 1
)

echo [INFO] Starting ADB and connecting to %ADB_HOST%...
adb start-server >nul
adb connect %ADB_HOST%

:: ===== Check device state =====
set "STATE="
for /f "delims=" %%G in ('adb -s %ADB_HOST% get-state 2^>nul') do set "STATE=%%G"
if /I not "!STATE!"=="device" (
  echo [ERROR] Device %ADB_HOST% not ready. get-state="!STATE!".
  echo         Check IP, ADB over TCP/IP, and USB debugging.
  goto END
)

:: ===== Try root and remount (OK if it fails on non-rooted devices) =====
adb -s %ADB_HOST% root
adb -s %ADB_HOST% remount

:: ===== Source APK paths =====
set "LAUNCHER_APK=%SCRIPT_HOME_DIRECTORY%apk\launcher242.apk"
set "SERVICE_APK=%SCRIPT_HOME_DIRECTORY%apk\service207.apk"
set "BROWSER_APK=%SCRIPT_HOME_DIRECTORY%apk\browser156.apk"

:: ===== Validate APKs exist =====
if not exist "%LAUNCHER_APK%"  ( echo [ERROR] Missing file: "%LAUNCHER_APK%"  & goto END )
if not exist "%SERVICE_APK%"   ( echo [ERROR] Missing file: "%SERVICE_APK%"   & goto END )
if not exist "%BROWSER_APK%"   ( echo [ERROR] Missing file: "%BROWSER_APK%"   & goto END )

:: ===== Clean old files FIRST (best effort) =====
echo [INFO] Cleaning old APKs...
adb -s %ADB_HOST% shell rm -f /vendor/app/Launcher/Launcher.apk
adb -s %ADB_HOST% shell rm -f /vendor/app/Service/Service.apk
adb -s %ADB_HOST% shell rm -f /vendor/app/Browser/Browser.apk

:: (Optional) also remove any stray APKs in these folders.
:: Uncomment if you want to remove all *.apk in each directory:
:: adb -s %ADB_HOST% shell rm -f /vendor/app/Launcher/*.apk
:: adb -s %ADB_HOST% shell rm -f /vendor/app/Service/*.apk
:: adb -s %ADB_HOST% shell rm -f /vendor/app/Browser/*.apk

:: ===== Ensure target directories exist =====
adb -s %ADB_HOST% shell mkdir -p /vendor/app/Launcher
adb -s %ADB_HOST% shell mkdir -p /vendor/app/Service
adb -s %ADB_HOST% shell mkdir -p /vendor/app/Browser

:: ===== Push new APKs =====
echo [INFO] Pushing APKs...
adb -s %ADB_HOST% push "%BROWSER_APK%"  /vendor/app/Browser/Browser.apk
adb -s %ADB_HOST% push "%LAUNCHER_APK%" /vendor/app/Launcher/Launcher.apk
adb -s %ADB_HOST% push "%SERVICE_APK%"  /vendor/app/Service/Service.apk


:: ===== Fix permissions / contexts (best effort) =====
adb -s %ADB_HOST% shell chown root:root /vendor/app/Launcher/Launcher.apk /vendor/app/Service/Service.apk /vendor/app/Browser/Browser.apk
adb -s %ADB_HOST% shell chmod 0644       /vendor/app/Launcher/Launcher.apk /vendor/app/Service/Service.apk /vendor/app/Browser/Browser.apk

echo [INFO] Done.
echo        Note: On stock devices /vendor is read-only; operations may fail without root.
echo        You may need to reboot: adb -s %ADB_HOST% reboot


echo.
echo [INFO] Done. Rebooting device now...
adb -s %ADB_HOST% reboot

:END
endlocal
pause