#!/usr/bin/bash

for certFile in *.cer; do
    # Check if the file exists
    if [ ! -e "$certFile" ]; then
        echo "Certificate file $certFile not found."
        continue
    fi

    conversion_success=false
    # Convert certificate to PEM format
    if openssl x509 -in "$certFile" -out "${certFile%.cer}.pem" 2>/dev/null; then
        certFile="${certFile%.cer}.pem"
        conversion_success=true
    else
        echo "Error converting $certFile to PEM format. Skipping..."
    fi

    # Extract subject hash
    certHash=$(openssl x509 -inform PEM -subject_hash_old -in "$certFile" | head -1)
    certHash="${certHash}.0"

    # Copy certificate to /system/etc/security/cacerts/
    cat "$certFile" > "$certHash"

    # Append certificate details to the file
    openssl x509 -inform PEM -text -in "$certFile" -out /dev/null >> "$certHash"

    # Push certificate to the device
   # adb push "$certHash" /system/etc/security/cacerts/

    echo "Hash"
    ls $certHash
    # Clean up
    #if [ "$conversion_success" = true ]; then
        #rm "$certFile"
    #fi
    #rm "$certHash"
done
