/*
 * Decompiled with CFR 0.152.
 */
package netsync;

import java.util.Hashtable;
import java.util.Scanner;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.util.StringUtils;

@SpringBootApplication
public class LDAP {
    public static void main(String[] args) {
        String inputText;
        String ldapUserName = "henry@netsyncdemo.com";
        Scanner sc = new Scanner(System.in);
        System.out.println("Please enter the provider url  (for example:ldap://dc.netsyncdemo.com:389):");
        String ldapUrl = inputText = sc.nextLine();
        System.out.println("Please enter the LDAP baseDN  (for example: dc=netsyncdemo,dc=com):");
        String baseDN = inputText = sc.nextLine();
        System.out.println("Please enter the password for user " + ldapUserName);
        String ldapPassword = inputText = sc.nextLine();
        if (!StringUtils.hasText((String)inputText)) {
            System.out.println("!! NOTE: password is empty, so try to login with default password, please do enter password incase of diff password");
            ldapPassword = "P@ssw0rd";
        }
        System.out.println("Please enter the username to search :");
        String username = inputText = sc.nextLine();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        String bindPrincipal = username;
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", ldapUrl);
        environment.put("java.naming.security.authentication", "simple");
        environment.put("java.naming.security.principal", ldapUserName);
        environment.put("java.naming.security.credentials", ldapPassword);
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        try {
            InitialDirContext context = new InitialDirContext(environment);
            String FILTER = "(&(objectClass=person)(sAMAccountName={0}))";
            String[] attrIDs = new String[]{"sn", "givenName"};
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            DirContextOperations results = SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)context, (SearchControls)searchControls, (String)baseDN, (String)FILTER, (Object[])new Object[]{bindPrincipal, username});
            System.out.println("user " + results);
        }
        catch (AuthenticationNotSupportedException exception) {
            System.out.println("The authentication is not supported by the server");
        }
        catch (AuthenticationException exception) {
            System.out.println("Incorrect password or username");
        }
        catch (NamingException exception) {
            System.out.println("Error when trying to create the context");
        }
    }
}

