/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AttributeSyntaxDefinition
extends SchemaElement {
    private static final long serialVersionUID = 8593718232711987488L;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String attributeSyntaxString;
    private final String oid;

    public AttributeSyntaxDefinition(String s) throws LDAPException {
        LinkedHashMap<String, String[]> exts;
        String descr;
        block9: {
            String token;
            Validator.ensureNotNull(s);
            this.attributeSyntaxString = s.trim();
            int length = this.attributeSyntaxString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_EMPTY.get());
            }
            if (this.attributeSyntaxString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_NO_OPENING_PAREN.get(this.attributeSyntaxString));
            }
            int pos = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = AttributeSyntaxDefinition.readOID(this.attributeSyntaxString, pos, length, buffer);
            this.oid = buffer.toString();
            descr = null;
            exts = new LinkedHashMap<String, String[]>(StaticUtils.computeMapCapacity(5));
            while (true) {
                int tokenStartPos = pos = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, pos, length);
                while (pos < length && this.attributeSyntaxString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.attributeSyntaxString.substring(tokenStartPos, pos);
                String lowerToken = StaticUtils.toLowerCase(token);
                if (lowerToken.equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_CLOSE_NOT_AT_END.get(this.attributeSyntaxString));
                    }
                    break block9;
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, pos, length);
                        buffer = new StringBuilder();
                        pos = AttributeSyntaxDefinition.readQDString(this.attributeSyntaxString, pos, length, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_MULTIPLE_DESC.get(this.attributeSyntaxString));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>(5);
                pos = AttributeSyntaxDefinition.readQDStrings(this.attributeSyntaxString, pos, length, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_DUP_EXT.get(this.attributeSyntaxString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_UNEXPECTED_TOKEN.get(this.attributeSyntaxString, token));
        }
        this.description = descr;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public AttributeSyntaxDefinition(String oid, String description, Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.description = description;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.attributeSyntaxString = buffer.toString();
    }

    private void createDefinitionString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.description != null) {
            buffer.append(" DESC '");
            AttributeSyntaxDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                AttributeSyntaxDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                AttributeSyntaxDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeSyntaxDefinition)) {
            return false;
        }
        AttributeSyntaxDefinition d = (AttributeSyntaxDefinition)o;
        return this.oid.equals(d.oid) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, d.description) && AttributeSyntaxDefinition.extensionsEqual(this.extensions, d.extensions);
    }

    @Override
    public String toString() {
        return this.attributeSyntaxString;
    }
}

