/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskState;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExecTask
extends Task {
    static final String EXEC_TASK_CLASS = "com.unboundid.directory.server.tasks.ExecTask";
    private static final String ATTR_COMMAND_PATH = "ds-task-exec-command-path";
    private static final String ATTR_COMMAND_ARGUMENTS = "ds-task-exec-command-arguments";
    private static final String ATTR_COMMAND_OUTPUT_FILE = "ds-task-exec-command-output-file";
    private static final String ATTR_LOG_COMMAND_OUTPUT = "ds-task-exec-log-command-output";
    private static final String ATTR_TASK_STATE_FOR_NONZERO_EXIT_CODE = "ds-task-exec-task-completion-state-for-nonzero-exit-code";
    private static final String ATTR_WORKING_DIRECTORY = "ds-task-exec-working-directory";
    private static final String OC_EXEC_TASK = "ds-task-exec";
    private static final TaskProperty PROPERTY_COMMAND_PATH = new TaskProperty("ds-task-exec-command-path", TaskMessages.INFO_EXEC_DISPLAY_NAME_COMMAND_PATH.get(), TaskMessages.INFO_EXEC_DESCRIPTION_COMMAND_PATH.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_COMMAND_ARGUMENTS = new TaskProperty("ds-task-exec-command-arguments", TaskMessages.INFO_EXEC_DISPLAY_NAME_COMMAND_ARGUMENTS.get(), TaskMessages.INFO_EXEC_DESCRIPTION_COMMAND_ARGUMENTS.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_COMMAND_OUTPUT_FILE = new TaskProperty("ds-task-exec-command-output-file", TaskMessages.INFO_EXEC_DISPLAY_NAME_COMMAND_OUTPUT_FILE.get(), TaskMessages.INFO_EXEC_DESCRIPTION_COMMAND_OUTPUT_FILE.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_LOG_COMMAND_OUTPUT = new TaskProperty("ds-task-exec-log-command-output", TaskMessages.INFO_EXEC_DISPLAY_NAME_LOG_COMMAND_OUTPUT.get(), TaskMessages.INFO_EXEC_DESCRIPTION_LOG_COMMAND_OUTPUT.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_TASK_STATE_FOR_NONZERO_EXIT_CODE = new TaskProperty("ds-task-exec-task-completion-state-for-nonzero-exit-code", TaskMessages.INFO_EXEC_DISPLAY_NAME_TASK_STATE_FOR_NONZERO_EXIT_CODE.get(), TaskMessages.INFO_EXEC_DESCRIPTION_TASK_STATE_FOR_NONZERO_EXIT_CODE.get(), String.class, false, false, false, new String[]{"STOPPED_BY_ERROR", "STOPPED-BY-ERROR", "COMPLETED_WITH_ERRORS", "COMPLETED-WITH-ERRORS", "COMPLETED_SUCCESSFULLY", "COMPLETED-SUCCESSFULLY"});
    private static final TaskProperty PROPERTY_WORKING_DIRECTORY = new TaskProperty("ds-task-exec-working-directory", TaskMessages.INFO_EXEC_DISPLAY_NAME_WORKING_DIRECTORY.get(), TaskMessages.INFO_EXEC_DESCRIPTION_WORKING_DIRECTORY.get(), String.class, false, false, false);
    private static final long serialVersionUID = -1647609631634328008L;
    private final Boolean logCommandOutput;
    private final String commandArguments;
    private final String commandOutputFile;
    private final String commandPath;
    private final String taskStateForNonZeroExitCode;
    private final String workingDirectory;

    public ExecTask() {
        this.commandPath = null;
        this.commandArguments = null;
        this.commandOutputFile = null;
        this.logCommandOutput = null;
        this.taskStateForNonZeroExitCode = null;
        this.workingDirectory = null;
    }

    public ExecTask(String commandPath, String commandArguments, String commandOutputFile, Boolean logCommandOutput, TaskState taskStateForNonZeroExitCode) throws TaskException {
        this(null, commandPath, commandArguments, commandOutputFile, logCommandOutput, taskStateForNonZeroExitCode, null, null, null, null, null);
    }

    public ExecTask(String commandPath, String commandArguments, String commandOutputFile, Boolean logCommandOutput, TaskState taskStateForNonZeroExitCode, String workingDirectory) throws TaskException {
        this(null, commandPath, commandArguments, commandOutputFile, logCommandOutput, taskStateForNonZeroExitCode, workingDirectory, null, null, null, null, null, null, null, null, null, null);
    }

    public ExecTask(String taskID, String commandPath, String commandArguments, String commandOutputFile, Boolean logCommandOutput, TaskState taskStateForNonZeroExitCode, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) throws TaskException {
        this(taskID, commandPath, commandArguments, commandOutputFile, logCommandOutput, taskStateForNonZeroExitCode, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public ExecTask(String taskID, String commandPath, String commandArguments, String commandOutputFile, Boolean logCommandOutput, TaskState taskStateForNonZeroExitCode, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) throws TaskException {
        this(taskID, commandPath, commandArguments, commandOutputFile, logCommandOutput, taskStateForNonZeroExitCode, null, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
    }

    public ExecTask(String taskID, String commandPath, String commandArguments, String commandOutputFile, Boolean logCommandOutput, TaskState taskStateForNonZeroExitCode, String workingDirectory, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) throws TaskException {
        super(taskID, EXEC_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.commandPath = commandPath;
        this.commandArguments = commandArguments;
        this.commandOutputFile = commandOutputFile;
        this.logCommandOutput = logCommandOutput;
        this.workingDirectory = workingDirectory;
        if (commandPath == null || commandPath.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_EXEC_MISSING_PATH.get());
        }
        if (taskStateForNonZeroExitCode == null) {
            this.taskStateForNonZeroExitCode = null;
        } else {
            switch (taskStateForNonZeroExitCode) {
                case STOPPED_BY_ERROR: 
                case COMPLETED_WITH_ERRORS: 
                case COMPLETED_SUCCESSFULLY: {
                    this.taskStateForNonZeroExitCode = taskStateForNonZeroExitCode.name();
                    break;
                }
                default: {
                    throw new TaskException(TaskMessages.ERR_EXEC_INVALID_STATE_FOR_NONZERO_EXIT_CODE.get(TaskState.STOPPED_BY_ERROR.name(), TaskState.COMPLETED_WITH_ERRORS.name(), TaskState.COMPLETED_SUCCESSFULLY.name()));
                }
            }
        }
    }

    public ExecTask(Entry entry) throws TaskException {
        super(entry);
        this.commandPath = entry.getAttributeValue(ATTR_COMMAND_PATH);
        if (this.commandPath == null) {
            throw new TaskException(TaskMessages.ERR_EXEC_ENTRY_MISSING_COMMAND_PATH.get(entry.getDN(), ATTR_COMMAND_PATH));
        }
        this.commandArguments = entry.getAttributeValue(ATTR_COMMAND_ARGUMENTS);
        this.commandOutputFile = entry.getAttributeValue(ATTR_COMMAND_OUTPUT_FILE);
        this.logCommandOutput = entry.getAttributeValueAsBoolean(ATTR_LOG_COMMAND_OUTPUT);
        this.taskStateForNonZeroExitCode = entry.getAttributeValue(ATTR_TASK_STATE_FOR_NONZERO_EXIT_CODE);
        this.workingDirectory = entry.getAttributeValue(ATTR_WORKING_DIRECTORY);
    }

    public ExecTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(EXEC_TASK_CLASS, properties);
        String path = null;
        String arguments = null;
        String outputFile = null;
        Boolean logOutput = null;
        String nonZeroExitState = null;
        String workingDir = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (attrName.equals(ATTR_COMMAND_PATH)) {
                path = ExecTask.parseString(p, values, path);
                continue;
            }
            if (attrName.equals(ATTR_COMMAND_ARGUMENTS)) {
                arguments = ExecTask.parseString(p, values, arguments);
                continue;
            }
            if (attrName.equals(ATTR_COMMAND_OUTPUT_FILE)) {
                outputFile = ExecTask.parseString(p, values, outputFile);
                continue;
            }
            if (attrName.equals(ATTR_LOG_COMMAND_OUTPUT)) {
                logOutput = ExecTask.parseBoolean(p, values, logOutput);
                continue;
            }
            if (attrName.equals(ATTR_TASK_STATE_FOR_NONZERO_EXIT_CODE)) {
                nonZeroExitState = ExecTask.parseString(p, values, nonZeroExitState);
                continue;
            }
            if (!attrName.equals(ATTR_WORKING_DIRECTORY)) continue;
            workingDir = ExecTask.parseString(p, values, workingDir);
        }
        this.commandPath = path;
        this.commandArguments = arguments;
        this.commandOutputFile = outputFile;
        this.logCommandOutput = logOutput;
        this.taskStateForNonZeroExitCode = nonZeroExitState;
        this.workingDirectory = workingDir;
        if (this.commandPath == null) {
            throw new TaskException(TaskMessages.ERR_EXEC_PROPERTIES_MISSING_COMMAND_PATH.get());
        }
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_EXEC.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_EXEC.get();
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public String getCommandArguments() {
        return this.commandArguments;
    }

    public String getCommandOutputFile() {
        return this.commandOutputFile;
    }

    public Boolean logCommandOutput() {
        return this.logCommandOutput;
    }

    public String getTaskStateForNonZeroExitCode() {
        return this.taskStateForNonZeroExitCode;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_EXEC_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        attrList.add(new Attribute(ATTR_COMMAND_PATH, this.commandPath));
        if (this.commandArguments != null) {
            attrList.add(new Attribute(ATTR_COMMAND_ARGUMENTS, this.commandArguments));
        }
        if (this.commandOutputFile != null) {
            attrList.add(new Attribute(ATTR_COMMAND_OUTPUT_FILE, this.commandOutputFile));
        }
        if (this.logCommandOutput != null) {
            attrList.add(new Attribute(ATTR_LOG_COMMAND_OUTPUT, String.valueOf(this.logCommandOutput)));
        }
        if (this.taskStateForNonZeroExitCode != null) {
            attrList.add(new Attribute(ATTR_TASK_STATE_FOR_NONZERO_EXIT_CODE, this.taskStateForNonZeroExitCode));
        }
        if (this.workingDirectory != null) {
            attrList.add(new Attribute(ATTR_WORKING_DIRECTORY, this.workingDirectory));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_COMMAND_PATH, PROPERTY_COMMAND_ARGUMENTS, PROPERTY_COMMAND_OUTPUT_FILE, PROPERTY_LOG_COMMAND_OUTPUT, PROPERTY_TASK_STATE_FOR_NONZERO_EXIT_CODE, PROPERTY_WORKING_DIRECTORY));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(StaticUtils.computeMapCapacity(6)));
        props.put(PROPERTY_COMMAND_PATH, Collections.singletonList(this.commandPath));
        if (this.commandArguments != null) {
            props.put(PROPERTY_COMMAND_ARGUMENTS, Collections.singletonList(this.commandArguments));
        }
        if (this.commandOutputFile != null) {
            props.put(PROPERTY_COMMAND_OUTPUT_FILE, Collections.singletonList(this.commandOutputFile));
        }
        if (this.logCommandOutput != null) {
            props.put(PROPERTY_LOG_COMMAND_OUTPUT, Collections.singletonList(this.logCommandOutput));
        }
        if (this.taskStateForNonZeroExitCode != null) {
            props.put(PROPERTY_TASK_STATE_FOR_NONZERO_EXIT_CODE, Collections.singletonList(this.taskStateForNonZeroExitCode));
        }
        if (this.workingDirectory != null) {
            props.put(PROPERTY_WORKING_DIRECTORY, Collections.singletonList(this.workingDirectory));
        }
        return Collections.unmodifiableMap(props);
    }
}

