/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.PasswordFileReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Arrays;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PasswordReader {
    private static volatile BufferedReader TEST_READER = null;
    private static volatile String DEFAULT_ENVIRONMENT_VARIABLE_VALUE = null;
    private static final String PASSWORD_FILE_ENVIRONMENT_VARIABLE = "LDAP_SDK_PASSWORD_READER_PASSWORD_FILE";

    private PasswordReader() {
    }

    public static char[] readPasswordChars() throws LDAPException {
        BufferedReader testReader = TEST_READER;
        if (testReader != null) {
            try {
                return testReader.readLine().toCharArray();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_PW_READER_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        String environmentVariableValue = StaticUtils.getEnvironmentVariable(PASSWORD_FILE_ENVIRONMENT_VARIABLE, DEFAULT_ENVIRONMENT_VARIABLE_VALUE);
        if (environmentVariableValue != null) {
            try {
                File f = new File(environmentVariableValue);
                PasswordFileReader r = new PasswordFileReader();
                return r.readPassword(f);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_PW_READER_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (System.console() == null) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_PW_READER_CANNOT_READ_PW_WITH_NO_CONSOLE.get());
        }
        return System.console().readPassword();
    }

    public static byte[] readPassword() throws LDAPException {
        char[] pwChars = PasswordReader.readPasswordChars();
        ByteStringBuffer buffer = new ByteStringBuffer();
        buffer.append(pwChars);
        Arrays.fill(pwChars, '\u0000');
        byte[] pwBytes = buffer.toByteArray();
        buffer.clear(true);
        return pwBytes;
    }

    @Deprecated
    public void run() {
    }

    @InternalUseOnly
    public static void setTestReaderLines(String ... lines) {
        ByteStringBuffer buffer = new ByteStringBuffer();
        for (String line : lines) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        TEST_READER = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer.toByteArray())));
    }

    @InternalUseOnly
    public static void setTestReader(BufferedReader reader) {
        TEST_READER = reader;
    }

    @InternalUseOnly
    static void setDefaultEnvironmentVariableValue(String value) {
        DEFAULT_ENVIRONMENT_VARIABLE_VALUE = value;
    }
}

